 function [fitstats, cfit, basicstats] = fit_gauss_func_Open(time, currentdata, expectedpeak);
%% fit_gauss_func_Open
% written by MSM (no idea when, very old function). Edited for readibility by BJD 5/5/2018.
% function that fits mean response rate across time during the peak interval
% procedure with a gaussian + kurtosis function.
%
% Inputs:
% 1. time: one-row vector with time-values that correspond to bins in mean response
% rate vector (see below). 
% 2. currentdata: one-row vector with mean probe-trial response rate in successive bins across time
% 3. expected peak: FI duration for the cue in question. Used to give
% starting points for fit function.
%
% Outputs:
% 1. fitstats: vector with timing data derived from the fit. Useable, but in my (BJD)
% opinion, too much data is given here. Therefore, a simplified vector is given separately
% (see below). 
% 2. cfit: fit object that can be used to plot fit result over actual
% response rate if desired. 
% 3. basicstats: vector with most relevant data (peak-time, CV,
% LHM-time, RHM-time, adjusted-rsquare). For virtually all purposes, the
% peak time and CV (spread/peaktime) are typically used as measures of timing 
% accuracy and precision, respectively. 
 
 %% basic setup for non-linear fit in matlab
    warning off 'all'
    x = time;
    expectedwidth = expectedpeak;
    maxval = max(currentdata);
    options = [maxval expectedpeak expectedpeak 2 0]; % starting points
    ftype = fittype('a*exp((-1/2)*(((abs(x-b))/c)^d))+e'); % fit equation
    opts = fitoptions('method', 'NonlinearLeastSquares','Robust','off','StartPoint',options, 'Lower', [0 0 0.000001 2 0], 'MaxFunEvals', 10000, 'MaxIter', 10000);

%% fit data
    [cfit,dfit,output] = fit(x',currentdata',ftype,opts);
    temp2 = struct(cfit);
    
%% extract relevant coefficients
    z2 = getfield(temp2, 'coeffValues', {1,1:5});
    z2 = cell2mat(z2);
    baseline = z2(1,5);
    e = z2(1,5);    
    a = z2(1,1);
    b = z2(1,2);
    
%% draw fit as vector over requested time bins (projected_data_time) 
    projected_data_time = min(time):.1:max(time);
    projected_data_time = projected_data_time';
    projected_data = cfit(projected_data_time); % vector representing fit across specifiend time points

%% begin extracting relevant statistics based on fit   
    max_projected = max(projected_data); 
    amplitude = max_projected'-baseline;
    peaktime = projected_data_time(projected_data==max_projected); % peak time. Mode of distribution. Most relevant here.
    if length(peaktime)>1
        peaktime = median(peaktime);
    end
    mode_of_peak = peaktime;

    sum_projected_data_by_time = sum(projected_data.*projected_data_time);
    sum_observations = sum(projected_data);
    mean_of_peak = sum_projected_data_by_time/sum_observations;

    halfmaxa = max_projected/2;
    halfmaxa_leftindex = find(projected_data>halfmaxa,1, 'first');
    halfmaxa_rightindex = find(projected_data>halfmaxa,1, 'last');
    halfmaxa_left_time = projected_data_time(halfmaxa_leftindex);
    halfmaxa_right_time = projected_data_time(halfmaxa_rightindex);
    
    quartermaxa = max_projected/4;
    quartermaxa_leftindex = find(projected_data>quartermaxa,1, 'first');
    quartermaxa_rightindex = find(projected_data>quartermaxa,1, 'last');
    quartermaxa_left_time = projected_data_time(quartermaxa_leftindex);
    quartermaxa_right_time = projected_data_time(quartermaxa_rightindex); 
    
    
   WHM = halfmaxa_right_time-halfmaxa_left_time; % FWHM. Typically, used to compute CVs, although using quarter max is also an option. 
   WHMleft = peaktime-halfmaxa_left_time;
   WHMright = halfmaxa_right_time-peaktime;
   
   WQM = quartermaxa_right_time-quartermaxa_left_time;
   WQMleft = peaktime-quartermaxa_left_time;
   WQMright = quartermaxa_right_time-peaktime; 
   
   c = z2(1,3);
   d = z2(1,4);
   
   adjrsquare = getfield(dfit, 'adjrsquare');
   SSfit = getfield(dfit, 'sse');
   cv1 = WHM/peaktime;
   cv2 = WQM/peaktime;
   
   peaktimeindex = find(projected_data_time==peaktime,1);
   AUCfitleft = sum(projected_data(1:peaktimeindex));
   AUCfitright = sum(projected_data(peaktimeindex:length(projected_data)));
   AUCfitasymmetry = AUCfitright/(AUCfitleft+AUCfitright);
   skew = 3*(mean_of_peak-mode_of_peak)/WHM;
   %% data vector in order that is probably only useful to the matell lab (keep consistent with old code). Lots of unneeded data.  
   fitstats = [amplitude peaktime WHM b cv1 halfmaxa_left_time halfmaxa_right_time (halfmaxa_right_time-peaktime)/(halfmaxa_right_time-halfmaxa_left_time) (quartermaxa_right_time-peaktime)/(quartermaxa_right_time-quartermaxa_left_time) AUCfitasymmetry skew adjrsquare a b c d e];
   
   %% data vector that is more broadly useful, including most relevant statistics.
   basicstats=[peaktime cv1 halfmaxa_left_time halfmaxa_right_time adjrsquare]; % peak time (primary focus in most cases), coefficient of variation, half max left time, half max right time, fit quality (adjusted r-squared).
 end
